<?php
session_start();
require_once 'config.php';

// Generate a new math problem if one doesn't exist or after a failed attempt
if (!isset($_SESSION['captcha_ans'])) {
    $num1 = rand(1, 15);
    $num2 = rand(1, 15);
    $_SESSION['captcha_ans'] = $num1 + $num2;
    $_SESSION['captcha_text'] = "$num1 + $num2";
}

if (isset($_POST['login'])) {
    $user = mysqli_real_escape_string($conn, $_POST['username']);
    $pass = $_POST['password'];
    $user_captcha = $_POST['captcha_input'];

    // 1. Check if the math calculation is correct
    if ($user_captcha != $_SESSION['captcha_ans']) {
        $error = "❌ Security Check Failed: Incorrect calculation.";
        // Reset math problem for next try
        unset($_SESSION['captcha_ans']);
    } else {
        // 2. Proceed with Database check
        $result = mysqli_query($conn, "SELECT * FROM admin_users WHERE username='$user'");
        $row = mysqli_fetch_assoc($result);

        if ($row && password_verify($pass, $row['password'])) {
            // SECURITY: Regenerate ID to prevent session hijacking
            session_regenerate_id(true);
            
            $_SESSION['admin_logged_in'] = true;
            
            // Clean up captcha
            unset($_SESSION['captcha_ans']);
            unset($_SESSION['captcha_text']);
            
            header("Location: index.php");
            exit();
        } else {
            $error = "❌ Invalid Credentials!";
            unset($_SESSION['captcha_ans']); // New math problem on failure
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Secure Admin Login</title>
    <link rel="stylesheet" href="style.css">
    <style>
        body { background: #f1f5f9; display: flex; justify-content: center; align-items: center; height: 100vh; font-family: sans-serif; }
        .login-box { background: white; padding: 40px; border-radius: 12px; box-shadow: 0 10px 25px rgba(0,0,0,0.1); width: 320px; }
        input { width: 100%; padding: 12px; margin: 10px 0; border: 1px solid #cbd5e1; border-radius: 6px; box-sizing: border-box; }
        .captcha-label { 
            background: #e2e8f0; 
            padding: 10px; 
            border-radius: 6px; 
            text-align: center; 
            font-weight: bold; 
            margin-bottom: 5px; 
            color: #1e293b;
        }
        button { 
            width: 100%; 
            background: #0f172a; 
            color: white; 
            padding: 12px; 
            border: none; 
            border-radius: 6px; 
            cursor: pointer; 
            font-weight: bold; 
            transition: 0.3s;
        }
        button:hover { background: #334155; }
        .error { color: #dc2626; text-align: center; font-size: 0.9em; margin-bottom: 10px; }
    </style>
</head>
<body>

<div class="login-box">
    <form method="POST" autocomplete="off">
        <h2 style="text-align: center; margin-bottom: 25px;">Admin Login</h2>
        
        <?php if(isset($error)) echo "<div class='error'>$error</div>"; ?>

        <input type="text" name="username" placeholder="Username" required>
        <input type="password" name="password" placeholder="Password" required>

        <div style="margin-top: 15px;">
            <div class="captcha-label">Solve: <?php echo $_SESSION['captcha_text']; ?> = ?</div>
            <input type="number" name="captcha_input" placeholder="Enter answer" required>
        </div>

        <button type="submit" name="login">Enter Dashboard</button>
    </form>
</div>

</body>
</html>