<?php 
include 'config.php'; 

// Function to fetch sums based on timeframe
function getSum($conn, $type, $timeframe) {
    if ($timeframe == 'daily') {
        $condition = "date_created = CURDATE()";
    } elseif ($timeframe == 'weekly') {
        $condition = "YEARWEEK(date_created, 1) = YEARWEEK(CURDATE(), 1)";
    } else {
        $condition = "MONTH(date_created) = MONTH(CURDATE()) AND YEAR(date_created) = YEAR(CURDATE())";
    }

    $sql = "SELECT SUM(amount) as total FROM transactions WHERE type='$type' AND $condition";
    $query = mysqli_query($conn, $sql);
    $data = mysqli_fetch_assoc($query);
    return $data['total'] ?? 0;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Financial Reports</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
    <a href="index.php">← Back to Dashboard</a>
    <h2>Detailed Expenditure & Income Reports</h2>

    <table class="report-table">
        <thead>
            <tr>
                <th>Period</th>
                <th>Total Income</th>
                <th>Total Expenditure</th>
                <th>Net Savings</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $d_inc = getSum($conn, 'income', 'daily');
            $d_exp = getSum($conn, 'expense', 'daily');
            ?>
            <tr>
                <td><strong>Today</strong></td>
                <td>$<?php echo number_format($d_inc, 2); ?></td>
                <td>$<?php echo number_format($d_exp, 2); ?></td>
                <td>$<?php echo number_format($d_inc - $d_exp, 2); ?></td>
            </tr>

            <?php 
            $w_inc = getSum($conn, 'income', 'weekly');
            $w_exp = getSum($conn, 'expense', 'weekly');
            ?>
            <tr>
                <td><strong>This Week</strong></td>
                <td>$<?php echo number_format($w_inc, 2); ?></td>
                <td>$<?php echo number_format($w_exp, 2); ?></td>
                <td>$<?php echo number_format($w_inc - $w_exp, 2); ?></td>
            </tr>

            <?php 
            $m_inc = getSum($conn, 'income', 'monthly');
            $m_exp = getSum($conn, 'expense', 'monthly');
            ?>
            <tr>
                <td><strong>This Month</strong></td>
                <td>$<?php echo number_format($m_inc, 2); ?></td>
                <td>$<?php echo number_format($m_exp, 2); ?></td>
                <td>$<?php echo number_format($m_inc - $m_exp, 2); ?></td>
            </tr>
        </tbody>
    </table>
</div>
</body>
</html>